/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.world.gen.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import org.infernalstudios.infernalexp.init.IEStructureTypes;
import org.infernalstudios.infernalexp.world.gen.structures.StructureUtil;
import org.jetbrains.annotations.NotNull;

public class StriderAltarStructure
extends Structure {
    private static final int MIN_VALID_SPACE = 20;
    public static final Codec<StriderAltarStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)StriderAltarStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool)).apply((Applicative)instance, StriderAltarStructure::new)).codec();
    private final Holder<StructureTemplatePool> startPool;

    public StriderAltarStructure(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool) {
        super(settings);
        this.startPool = startPool;
    }

    @NotNull
    public Optional<Structure.GenerationStub> m_214086_(@NotNull Structure.GenerationContext context) {
        BlockPos pos = context.f_226628_().m_151394_(0);
        NoiseColumn column = context.f_226622_().m_214184_(pos.m_123341_(), pos.m_123343_(), context.f_226629_(), context.f_226624_());
        int maxHeight = Math.min(context.f_226622_().m_6331_(), context.f_226622_().m_6337_() + 20);
        for (int y = context.f_226622_().m_6337_(); y < maxHeight; ++y) {
            if (column.m_183556_(y).m_60795_()) continue;
            return Optional.empty();
        }
        Optional<Integer> yLevel = StructureUtil.getNetherLavaFloorY(context, pos);
        if (yLevel.isEmpty()) {
            return Optional.empty();
        }
        pos = pos.m_6630_(yLevel.get().intValue());
        return JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, Optional.empty(), (int)1, (BlockPos)pos, (boolean)false, Optional.empty(), (int)1);
    }

    @NotNull
    public StructureType<?> m_213658_() {
        return IEStructureTypes.STRIDER_ALTAR;
    }
}

